/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class Card
implements Comparable<Card>,
class_3542 {
    private static final Card[] CARDS = new Card[Suit.values().length * Rank.values().length];
    public static final Codec<Card> CODEC;
    public static final class_9139<ByteBuf, Card> STREAM_CODEC;
    public static final Card BLANK;
    private final Suit suit;
    private final Rank rank;
    private boolean flipped;

    public Card(Suit suit, Rank rank) {
        this(suit, rank, false);
    }

    public Card(Suit suit, Rank rank, boolean flipped) {
        this.suit = suit;
        this.rank = rank;
        this.flipped = flipped;
    }

    public Suit getSuit() {
        return this.suit;
    }

    public Rank getRank() {
        return this.rank;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void flip() {
        this.flipped = !this.flipped;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Card card = (Card)obj;
        return this.flipped == card.flipped && this.suit == card.suit && this.rank == card.rank;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.suit, this.rank, this.flipped});
    }

    @Override
    public int compareTo(Card other) {
        int suitComparison = this.suit.compareTo(other.suit);
        if (suitComparison != 0) {
            return suitComparison;
        }
        return this.rank.compareTo(other.rank);
    }

    public String toString() {
        return this.suit.method_15434() + ":" + this.rank.method_15434();
    }

    public static DataResult<Card> read(String string) {
        try {
            String[] in = string.split(":");
            Card card = new Card(Suit.valueOf(in[0].toUpperCase()), Rank.valueOf(in[1].toUpperCase()));
            return DataResult.success((Object)card);
        }
        catch (Exception e) {
            return DataResult.error(() -> "Not a valid card: " + string + " " + e.getMessage());
        }
    }

    @NotNull
    public String method_15434() {
        return this.toString();
    }

    public static Card[] values() {
        return CARDS;
    }

    public Card copy() {
        return new Card(this.suit, this.rank, this.flipped);
    }

    static {
        int i = 0;
        for (Suit suit : Suit.values()) {
            for (Rank rank : Rank.values()) {
                Card.CARDS[i++] = new Card(suit, rank);
            }
        }
        CODEC = Codec.STRING.comapFlatMap(Card::read, Card::toString).stable();
        STREAM_CODEC = class_9139.method_56436(Suit.STREAM_CODEC, Card::getSuit, Rank.STREAM_CODEC, Card::getRank, (class_9139)class_9135.field_48547, Card::isFlipped, Card::new);
        BLANK = new Card(Suit.BLANK, Rank.BLANK, true);
    }
}

